/** OTLN.h

	 1993 by The Company of Science & Art

	Public includes.
	
**/
#ifndef _H_OTLN
#define _H_OTLN

//	"OTLNp.h"
/* set OTLNp_CODE_VERSION to zero when changing this constant */

#define	OS_MAC

#define OTLN_API_VERSION			19
#define OTLN_API_SUBVERS			' '

/* this is the value taken from the pkg.list file */
#define OTLN_PKG_ID				40

enum {
    Err_NONE = 0,
    Err_GENERIC,        /* generic */
    Err_MAGIC,          /* corrupted structure */
    Err_PARAMETER,      /* bad param passed to a routine */
    Err_ALLOC,          /* out of memory */
    Err_UNIMPLEMENTED,  /* for not yet done routines/options */
    Err_RESOURCE,       /* missing or bad resource */
    Err_OUT_OF_DATE,    /* (.h file) is out of date */
    Err_ENVIRONMENT,    /* not supported in this environment */
    Err_VERSION,        /* (document) version not supported */
    Err_RANGE,          /* internal value out of range */
    Err_UNDERBIRTH,     /* ?_Birth was not called */
    Err_OVERBIRTH,       /* ?_Death called too many times or corrupted */
	
	OTLN_Err_NIFTY_ERROR
};
typedef long	Err;

typedef	Rect	M_Rect;

#define		DH(foo)		(*foo)

/**************************************************************
			
	OTLN_Main.h
										
 **************************************************************/
#define		OTLN_MAX_NAME_LENGTH		48

enum	{
	OTLN_TopicFlags_COLLAPSED			= 0x0001,
	OTLN_TopicFlags_HAS_ICON			= 0x0002, 
	OTLN_TopicFlags_HAS_SEPARATOR		= 0x0004, 	//	separator line is drawn ABOVE this topic
	OTLN_TopicFlags_IS_SELECTABLE		= 0x0008, 	//	may not use now but it is there if needed

	OTLN_TopicFlags_IS_SELECTED			= 0x0010, 
	OTLN_TopicFlags_HAS_NUMBER			= 0x0020, 
	OTLN_TopicFlags_IS_EXPANDABLE		= 0x0040, 
	OTLN_TopicFlags_IS_FAMILY_INVISABLE	= 0x0080,

	OTLN_TopicFlags_IS_TOPIC_INVISABLE	= 0x0100, 
	OTLN_TopicFlags_IS_TOPIC_SOLO		= 0x0200, 
	OTLN_TopicFlags_NON2				= 0x0400, 
	OTLN_TopicFlags_NON1				= 0x0800,

	OTLN_TopicFlags_ALL_FLAGS_MASK		= 0x0FFF
};
typedef	unsigned short	OTLN_TopicFlags;

#define		OTLN_GET_TopicH_FLAGS(topic)			((*topic)->flags)
#define		OTLN_SET_TopicH_FLAGS(topic, flags)		((*topic)->flags = flags)

#define		OTLN_GET_TopicP_FLAGS(topic)			((topic)->flags)
#define		OTLN_SET_TopicP_FLAGS(topic, flags)		((topic)->flags = flags)

#define		OTLN_IS_TopicFlag_SET(flags, bit)		(((flags) & (bit)) != 0)
#define		OTLN_TopicFlag_SET(flags, bit)			(flags) |= (bit)
#define		OTLN_TopicFlag_CLEAR(flags, bit)		(flags) &= (OTLN_TopicFlags_ALL_FLAGS_MASK ^ (bit))
#define		OTLN_TopicFlag_FLIP(flags, bit)			(flags) ^= (bit)
#define		OTLN_TopicFlag_RESET(flags, bit, state)			\
	do {													\
		if (state) 											\
			OTLN_TopicFlag_SET(flags, bit);					\
		else												\
			OTLN_TopicFlag_CLEAR(flags, bit);				\
	} while (0)

#define		OTLN_IS_TopicFlag_COLLAPSED(topic)				\
	OTLN_IS_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_COLLAPSED)
#define		OTLN_SetTopicFlag_COLLAPSED(topic)				\
	OTLN_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_COLLAPSED)
#define		OTLN_ClearTopicFlag_COLLAPSED(topic)			\
	OTLN_TopicFlag_CLEAR(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_COLLAPSED)
#define		OTLN_FlipTopicFlag_COLLAPSED(topic)				\
	OTLN_TopicFlag_FLIP(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_COLLAPSED)
#define		OTLN_ResetTopicFlag_COLLAPSED(topic, state)		\
	OTLN_TopicFlag_RESET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_COLLAPSED, state)

#define		OTLN_IS_TopicFlag_SELECTED(topic)				\
	OTLN_IS_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_SELECTED)
#define		OTLN_SetTopicFlag_SELECTED(topic)				\
	OTLN_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_SELECTED)
#define		OTLN_ClearTopicFlag_SELECTED(topic)				\
	OTLN_TopicFlag_CLEAR(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_SELECTED)
#define		OTLN_FlipTopicFlag_SELECTED(topic)				\
	OTLN_TopicFlag_FLIP(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_SELECTED)
#define		OTLN_ResetTopicFlag_SELECTED(topic, state)		\
	OTLN_TopicFlag_RESET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_SELECTED, state)

#define		OTLN_IS_TopicFlag_EXPANDABLE(topic)				\
	OTLN_IS_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_EXPANDABLE)
#define		OTLN_SetTopicFlag_EXPANDABLE(topic)				\
	OTLN_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_EXPANDABLE)
#define		OTLN_ClearTopicFlag_EXPANDABLE(topic)			\
	OTLN_TopicFlag_CLEAR(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_EXPANDABLE)
#define		OTLN_FlipTopicFlag_EXPANDABLE(topic)			\
	OTLN_TopicFlag_FLIP(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_EXPANDABLE)
#define		OTLN_ResetTopicFlag_EXPANDABLE(topic, state)	\
	OTLN_TopicFlag_RESET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_EXPANDABLE, state)

#define		OTLN_IS_TopicFlag_FAMILY_INVISABLE(topic)			\
	OTLN_IS_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_FAMILY_INVISABLE)
#define		OTLN_SetTopicFlag_FAMILY_INVISABLE(topic)			\
	OTLN_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_FAMILY_INVISABLE)
#define		OTLN_ClearTopicFlag_FAMILY_INVISABLE(topic)			\
	OTLN_TopicFlag_CLEAR(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_FAMILY_INVISABLE)
#define		OTLN_FlipTopicFlag_FAMILY_INVISABLE(topic)			\
	OTLN_TopicFlag_FLIP(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_FAMILY_INVISABLE)
#define		OTLN_ResetTopicFlag_FAMILY_INVISABLE(topic, state)	\
	OTLN_TopicFlag_RESET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_FAMILY_INVISABLE, state)

#define		OTLN_IS_TopicFlag_TOPIC_INVISABLE(topic)			\
	OTLN_IS_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_INVISABLE)
#define		OTLN_SetTopicFlag_TOPIC_INVISABLE(topic)			\
	OTLN_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_INVISABLE)
#define		OTLN_ClearTopicFlag_TOPIC_INVISABLE(topic)			\
	OTLN_TopicFlag_CLEAR(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_INVISABLE)
#define		OTLN_FlipTopicFlag_TOPIC_INVISABLE(topic)			\
	OTLN_TopicFlag_FLIP(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_INVISABLE)
#define		OTLN_ResetTopicFlag_TOPIC_INVISABLE(topic, state)	\
	OTLN_TopicFlag_RESET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_INVISABLE, state)

#define		OTLN_IS_TopicFlag_TOPIC_SOLO(topic)				\
	OTLN_IS_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_SOLO)
#define		OTLN_SetTopicFlag_TOPIC_SOLO(topic)				\
	OTLN_TopicFlag_SET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_SOLO)
#define		OTLN_ClearTopicFlag_TOPIC_SOLO(topic)			\
	OTLN_TopicFlag_CLEAR(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_SOLO)
#define		OTLN_FlipTopicFlag_TOPIC_SOLO(topic)			\
	OTLN_TopicFlag_FLIP(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_SOLO)
#define		OTLN_ResetTopicFlag_TOPIC_SOLO(topic, state)	\
	OTLN_TopicFlag_RESET(OTLN_GET_TopicH_FLAGS(topic), OTLN_TopicFlags_IS_TOPIC_SOLO, state)

/**************************************************************
			define Outline and Topic structures to exist							
 **************************************************************/

typedef struct Outline_struct			OTLN_OutlineRec, *OTLN_OutlineP, **OTLN_OutlineH;
typedef struct Topic_struct				OTLN_TopicRec, *OTLN_TopicP, **OTLN_TopicH;

/**************************************************************
	hit/draw
 **************************************************************/

enum	{
	OTLN_Action_NONE = -1, 
	OTLN_Action_HIT, 
	OTLN_Action_DRAW, 
	OTLN_Action_NUMTYPES
};
typedef	short	OTLN_ActionType;

enum	{
	OTLN_Where_NONE, 
	OTLN_Where_LEFT, 
	OTLN_Where_CENTER, 
		OTLN_Where_TWIRLY, 
		OTLN_Where_NUMBER, 
		OTLN_Where_ICON, 
		OTLN_Where_NAME, 
	OTLN_Where_RIGHT
};
typedef short	OTLN_WhereType;

typedef struct {
	Point				hit_point;		//		>>	point we're looking for (only for hit)
	short				modifier_keys;	//		>>	modifiers				(only for hit)
	long				user_hit_data;	//		<>	custom hit place		(only for hit)
	OTLN_OutlineH		outline;		//		<<	outline that was hit	(rarely used)
	OTLN_TopicH			topic;			//		<<	topic that was hit
	OTLN_ActionType		action;			//		<<	action performed (hit/draw)
	OTLN_WhereType		where;			//		<<	where did it hit?
	Rect				rect;			//		<<	cell hit
} OTLN_Hit_n_Draw_Record;

typedef struct {
	OTLN_OutlineH	outlineH;
	OTLN_TopicH		topicH;
} OTLN_OutlineAndTopic, *OTLN_OutlineAndTopicP;

typedef		Err		(*OTLN_CustomHitCheck)(OTLN_Hit_n_Draw_Record *hitDraw_rec);
typedef		Err		(*OTLN_CustomDraw)(OTLN_Hit_n_Draw_Record *hitDraw_rec);
typedef		Err		(*OTLN_DisposeCustomData)(void *custom_data);
typedef		Err		(*OTLN_DupCustomData)(
	OTLN_OutlineAndTopic	*to_source0, 		//	always passed out, but may be ignored
	void					*custom_source, 
	OTLN_OutlineAndTopic	*to_dest0, 			//	always passed out, but may be ignored
	void 					**custom_dest);

/**************************************************************
	drag reorder
 **************************************************************/

enum	{
	OTLN_DragReorderCBMessage_NONE, 
	OTLN_DragReorderCBMessage_CLEAR, 
	OTLN_DragReorderCBMessage_DRAG, 
	OTLN_DragReorderCBMessage_TO_FRONT, 
	OTLN_DragReorderCBMessage_AFTER, 
	OTLN_DragReorderCBMessage_SCROLL_UP, 
	OTLN_DragReorderCBMessage_SCROLL_DOWN
};
typedef	short	OTLN_DragReorderCBMessageType;

typedef	struct {
	union {
		OTLN_TopicH			topic;
		struct {
			short			pixels;
			Rect			*frame_rect;
		} p;
	} u;
} OTLN_DragReorderDataRec;

typedef	Err		OLTN_DragReorderTopicCB(
	OTLN_DragReorderCBMessageType	message, 
	OTLN_DragReorderDataRec			*dragData, 
	void							*userData
);

#define		OTLN_DRAG_REORDER_SENTINEL	-100	//	used during drag-reordering

/**************************************************************
			Outline Struct							
 **************************************************************/

struct	Outline_struct {
	long			magic1;
	
	Rect			bounds;					//	size of visible outline plus custom areas
	short			outline_left;			//	screen pos of left edge of outline
	short			outline_right;			//	screen pos of right edge of outline
	short			cell_height;			//	height of cell (all cells same height or multiple)
	
	void			*iconsH;				//	if not NULL, handle list of icons
	Boolean			shared_icons;			//	ie: don't dispose them when disposing outline
	Boolean			honor_family_invisable;		//	do I pay attention to the invisable flag?
	Boolean			honor_topic_invisable;		//	do I pay attention to the invisable flag?

#if defined(OS_MAC)
	short			font_id;
	short			font_size;
#endif
	
	OTLN_TopicH		recent_topic;
	OTLN_TopicH		outline_root;

	void					*custom_data;
	OTLN_DupCustomData		dup_custom_data;
	OTLN_DisposeCustomData	dispose_custom_data;

#if defined(OS_MAC)
	//	only necessary on the mac cuz I DON'T want to call RecoverHandle()
	OTLN_OutlineH	self;					//	handle to myself
#endif

	long			magic2;
};

/**************************************************************
			Topic Struct							
 **************************************************************/
struct Topic_struct {
	long					magic1;
	
	char					name[OTLN_MAX_NAME_LENGTH + 1];

	OTLN_TopicFlags			flags;
	short					icon_reference;			//	if hasIcon then this is its index
	short					topicNumber;			//	if hasNumber then this is number
	
	short					cell_height_multiple;	//	normally 1, could be more
	
#if defined(OS_MAC)
	Style					font_style;
#endif

	OTLN_CustomHitCheck		custom_hit_check;
	OTLN_CustomDraw			custom_draw;
	void					*custom_data;
	OTLN_DupCustomData		dup_custom_data;
	OTLN_DisposeCustomData	dispose_custom_data;
	
	Rect					recent_cell;		//	most recent drawing location
	
	OTLN_TopicH				mother;
	OTLN_TopicH				daughters;
	OTLN_TopicH				prev_sister;
	OTLN_TopicH				next_sister;

#if defined(OS_MAC)
	//	only necessary on the mac cuz I DON'T want to call RecoverHandle()
	OTLN_TopicH				self;			//	handle to myself
#endif

	long					magic2;
};

#define		OTLN_Topic_RECENT_CELL(TOPIC)		(*TOPIC)->recent_cell

/**************************************************************
			OTLN_Main.h							
 **************************************************************/

Err		OTLN_Birth(void);
Err		OTLN_Death(void);

Err		OTLN_NewOutline(
				Rect				*bounds0, 
				OTLN_OutlineH		*outline);
				
Err		OTLN_DisposeOutline(OTLN_OutlineH outline);

Err		OTLN_SetOutlineSpecs(	
				OTLN_OutlineH		outline, 
				Rect				*bounds0, 
				short				*outline_left0, 
				short				*outline_right0, 
			#if defined(OS_MAC)
				const char			*font_name0, 
				short				font_size0, 
			#endif
				void 				*iconsH0, 
				Boolean				shared_icons);

Err		OTLN_SetOutlineCustomData(
	OTLN_OutlineH			outline, 
	void					*custom_data, 
	OTLN_DupCustomData		dup_custom_data, 
	OTLN_DisposeCustomData	dispose_custom_data
);

Err		OTLN_GetOutlineCustomData(
	OTLN_OutlineH	outline, 
	void			**customData
);

Err		OTLN_SetOutlineInvisableFlags(
				OTLN_OutlineH	outline, 
				Boolean			*honor_family_invisable, 
				Boolean			*honor_topic_invisable);

Err		OTLN_GetOutlineInvisableFlags(
				OTLN_OutlineH	outline, 
				Boolean			*honor_family_invisable, 
				Boolean			*honor_topic_invisable);

Err		OTLN_DupOutline(
	OTLN_OutlineH	outline, 
	OTLN_OutlineH	*outlineCopy
);

Err		OTLN_NewTopic(const char *name0, OTLN_TopicH *topic);
Err		OTLN_DisposeTopic(OTLN_TopicH topic);
Err		OTLN_SetTopicSpecs(
				OTLN_TopicH			topic, 
				const char			*name0,
				short				cell_height_multiple0, 
				OTLN_TopicFlags		flags0, 
				short				*icon_reference0, 
			#if defined(OS_MAC)
				Style				*font_style0);
			#endif

Err		OTLN_GetTopicCallbacks(
				OTLN_TopicH				topic, 
				OTLN_CustomHitCheck		*custom_hit_check0, 
				OTLN_CustomDraw			*custom_draw0, 
				void					**custom_data0,
				OTLN_DupCustomData		*dup_custom_data0,
				OTLN_DisposeCustomData	*dispose_custom_data0);

Err		OTLN_SetTopicCallbacks(
				OTLN_TopicH				topic, 
				OTLN_CustomHitCheck		custom_hit_check0, 
				OTLN_CustomDraw			custom_draw0, 
				void					*custom_data0, 
				OTLN_DupCustomData		dup_custom_data0, 
				OTLN_DisposeCustomData	dispose_custom_data0);

Err		OTLN_GetTopicCustomData(
				OTLN_TopicH				topic, 
				void					**customData);

/**************
	add/remove
*/
enum {
	OTLN_AddTopicAs_AUNT = -1, OTLN_AddTopicAs_SISTER, OTLN_AddTopicAs_LAST_DAUGHTER, 
	OTLN_AddTopicAs_FIRST_DAUGHTER = 1000
};
typedef	short	OTLN_AddTopicAsType;

Err		OTLN_AddTopic(
				OTLN_OutlineH		outline, 
				OTLN_TopicH			topic, 
				OTLN_TopicH			reference_topic0, 	//	>> if NULL, then 'where' is ignored;
				OTLN_AddTopicAsType	where);

Err		OTLN_AddNewTopic(
				OTLN_OutlineH		outline, 
				const char			*name0, 
				OTLN_AddTopicAsType	where, 
				OTLN_TopicH			*return0);

Err		OTLN_RemoveTopic(
				OTLN_OutlineH		outline,
				OTLN_TopicH			topic);

Err		OTLN_DupTopic(
			OTLN_TopicH	topic, 			//	>>
			OTLN_TopicH	*topicCopy		//	<<	will be allocated and passed back
		);

Err		OTLN_ReorderTopics(
			OTLN_OutlineH	outline, 
			OTLN_TopicH		parent0, 
			OTLN_TopicH		topic0, 	//	either pass the topic that is to be moved
			long			oldIndex0, 	//	or pass its index.  you MUST pass one
			long			newIndex
		);

/**************
	access
*/
#define		OTLN_FOR_EACH(MOTHER_TOPIC, TOPIC_INDEX, TOPIC, ERR)		\
	TOPIC_INDEX = 0;													\
	if (!ERR) ERR = OTLN_GetFirstDaughter(MOTHER_TOPIC, &TOPIC);		\
	if (!ERR && TOPIC) do {

#define		OTLN_END_EACH(TOPIC_INDEX, TOPIC, ERR)						\
		TOPIC_INDEX++;													\
		if (!ERR) ERR = OTLN_GetNextSister(TOPIC, &TOPIC);				\
	} while (!ERR && TOPIC)

Err		OTLN_GetTopicIndex(
			OTLN_OutlineH	outline, 			//	>>	the Outline
			OTLN_TopicH		topic, 				//	>>	the topic that you want to know about
			long			*index				//	<<	here's its index
		);

Err		OTLN_GetIndTopic(
			OTLN_OutlineH 	outline, 
			OTLN_TopicH		parent0, 
			long			index, 
			OTLN_TopicH		*topic
		);

Err		OTLN_GetRecentTopic(
				OTLN_OutlineH	outline, 
				OTLN_TopicH		*recent);
				
Err		OTLN_SetRecentTopic(
				OTLN_OutlineH	outline, 
				OTLN_TopicH		recent);

//--
Err		OTLN_GetTopicOutline(
				OTLN_TopicH		topic, 
				OTLN_OutlineH	*outline);

Err		OTLN_IsRootTopic(
				OTLN_OutlineH	outline, 
				OTLN_TopicH		topic, 
				Boolean			*isRoot);

Err		OTLN_GetRootTopic(
				OTLN_OutlineH	outline, 
				OTLN_TopicH		*root);

Err		OTLN_GetFirstTopic(
				OTLN_OutlineH	outline, 
				OTLN_TopicH		*topic);
//--
Err		OTLN_GetFirstDaughter(
				OTLN_TopicH mother, 
				OTLN_TopicH *first_daughter);

Err		OTLN_GetLastDaughter(
				OTLN_TopicH mother, 
				OTLN_TopicH *last_daughter);
//--
Err		OTLN_GetMother(
				OTLN_TopicH daughter, 
				OTLN_TopicH *mother);
				
//--
Err		OTLN_GetNextSister(
				OTLN_TopicH sister, 
				OTLN_TopicH *next_sister);

Err		OTLN_GetPrevSister(
				OTLN_TopicH sister, 
				OTLN_TopicH *prev_sister);
//--
Err		OTLN_GetFirstSister(
				OTLN_TopicH sister, 
				OTLN_TopicH *first_sister);

Err		OTLN_GetLastSister(
				OTLN_TopicH sister, 
				OTLN_TopicH *last_sister);

/**************************************************************
			
	OTLN_Iterate.h
										
 **************************************************************/
enum {
	OTLN_Iterate_NONE					= 0, 
	OTLN_Iterate_ALL					= 1, 
	OTLN_Iterate_ONE					= 2, 
	OTLN_Iterate_SISTERS				= 3, 
	OTLN_Iterate_CHILDREN				= 4, 
	OTLN_Iterate_SISTERS_AND_CHILDREN	= 5, 
	OTLN_Iterate_FAMILY					= 6, 
	OTLN_Iterate_unused9				= 7, 
	OTLN_Iterate_unused8				= 8, 
	OTLN_Iterate_unused7				= 9, 
	OTLN_Iterate_unused6				= 10, 
	OTLN_Iterate_unused5				= 11, 
	OTLN_Iterate_unused4				= 12, 
	OTLN_Iterate_unused3				= 13, 
	OTLN_Iterate_unused2				= 14, 
	OTLN_Iterate_unused1				= 15, 

	OTLN_IterateMod_ONSCREEN			= 0x00000010, 
	OTLN_IterateMod_ONSCREEN_FAMILIES	= 0x00000020, 
	OTLN_IterateMod_UNCOLLAPSED			= 0x00000040, 
	OTLN_IterateMod_SELECTED			= 0x00000080, 
	OTLN_IterateMod_UNSELECTED			= 0x00000100, 
	OTLN_IterateMod_UNSHY				= 0x00000200, 
	OTLN_IterateMod_VISIBLE				= 0x00000400, 
	OTLN_IterateMod_Unused1				= 0xFFFFF800
};
typedef	long	OTLN_IterateType;

#define	OTLN_IterateComp_STD			\
	OTLN_Iterate_ALL 					\
		+ OTLN_IterateMod_UNCOLLAPSED 	\
		+ OTLN_IterateMod_UNSHY 		\
		+ OTLN_IterateMod_VISIBLE 

#define	OTLN_IterateComp_STD_ONSCREEN	\
	OTLN_Iterate_ALL 					\
		+ OTLN_IterateMod_ONSCREEN 		\
		+ OTLN_IterateMod_UNCOLLAPSED 	\
		+ OTLN_IterateMod_UNSHY 		\
		+ OTLN_IterateMod_VISIBLE 

#define	OTLN_IterateComp_STD_ONSCREEN_FAMILIES	\
	OTLN_Iterate_ALL 							\
		+ OTLN_IterateMod_ONSCREEN_FAMILIES 	\
		+ OTLN_IterateMod_UNSHY 				\
		+ OTLN_IterateMod_VISIBLE 

/**********************************************************************/
#define		OTLN_GenericCallbackDataHeader	\
	Boolean			done;					\
	Boolean			skip_this_family;

typedef	struct {
	OTLN_GenericCallbackDataHeader
} OTLN_GenericCallbackData;

typedef	Err		(*OTLN_IterateOutlineCallback)(
					OTLN_OutlineP					ol, 
					OTLN_TopicP						to, 	
					Rect							*cell_rect, 
					OTLN_GenericCallbackData		*callback_data);
	
Err				OTLN_IterateOutline(
					OTLN_OutlineH					outline, 
					OTLN_TopicH						start_topic0, 
					OTLN_IterateType				iterate_type, 
					OTLN_IterateOutlineCallback		callback, 
					OTLN_GenericCallbackData		*callback_data0);

typedef	Err		(*OTLN_IterateDeepSelectionCB)(
	OTLN_OutlineH				outline, 
	OTLN_TopicH					topic, 
	void						*custom_data, 
	OTLN_GenericCallbackData	*callback_data
);

Err		OTLN_IterateDeepSelection(
	OTLN_OutlineH					outline, 
	OTLN_IterateDeepSelectionCB		callback, 
	OTLN_GenericCallbackData		*callback_data
);

/**************************************************************
			
	OTLN_Interface.h
										
 **************************************************************/
Err			OTLN_DrawTwirlieArrow(short xPos, short yPos, Boolean up);
Err			OTLN_TwirlArrow(Rect *destRect, Boolean twirlDown);
void		OTLN_HiliteArrow(Rect *theRect, void *data, Boolean in, Boolean Last);

Err			OTLN_DrawTopics(OTLN_OutlineH outline);
Err			OTLN_DrawTopicDefault(OTLN_Hit_n_Draw_Record *drawRec);

Err			OTLN_TestHitTopics(
					OTLN_OutlineH			outline, 
					OTLN_Hit_n_Draw_Record	*hitRec);
Err			OTLN_TestHitTopicDefault(OTLN_Hit_n_Draw_Record *hitRec);
					
Err			OTLN_CountTopics(
					OTLN_OutlineH		outline, 
					OTLN_IterateType	iterate_type, 
					Boolean				countCells, 
					long				*total);

typedef struct OTLN_OutlineSave_struct		OTLN_OutlineSaveRec,	*OTLN_OutlineSaveP,	**OTLN_OutlineSaveH;
typedef struct OTLN_TopicSave_struct		OTLN_TopicSaveRec,		*OTLN_TopicSaveP,	**OTLN_TopicSaveH;

Err			OTLN_SaveTopics(
					OTLN_OutlineH		outline, 
					OTLN_OutlineSaveH	*save);
					
Err			OTLN_RestoreTopics(
					OTLN_OutlineH		outline, 
					OTLN_OutlineSaveH	*save);

Err		OTLN_TestTopicHit(
			OTLN_OutlineH		outline, 
			short				vPos, 
			OTLN_TopicH			excludeTopic, 
			OTLN_TopicH			*afterTopic, 
			short				*newVpos
		);

Err		OTLN_IsVisible(
	OTLN_OutlineH	outline, 
	OTLN_TopicH		topic, 
	Boolean			*is_onscreen);

Err		OTLN_ClearRecentRects(OTLN_OutlineH outline);

Err		OTLN_DragReorderAutoscrollSetup(
	OTLN_DragReorderCBMessageType	message, 		//	IN
	long							pixels, 		//	IN
	Rect							*min_frame, 	//	IN
	Rect							*max_frame, 	//	OUT
	Point							*the_point);	//	OUT
	

/**************************************************************
			
	OTLN_dmInterface.h
										
 **************************************************************/

Err			OTLN_DrawName(OTLN_OutlineP ol, OTLN_TopicP to, Rect *theRect);

#if defined(OS_MAC)
	Err		OTLN_SetFontInfo(OTLN_OutlineP ol, const char *font_name0, short font_size0);
	Err		OTLN_SetTopicFontStyle(OTLN_TopicP to, Style *font_style0);

	Err		OTLN_DrawSeparationBar(Rect *frame_rect, short vPos);
	Err		OTLN_DrawOutlineSeparationBar(void);
	
	Err		OTLN_DragReorderTopic(
		OTLN_Hit_n_Draw_Record	*hitDrawRec, 
		OLTN_DragReorderTopicCB	*callback, 
		void					*data, 
		Rect					*frame_rect, 
		long					cell_height0, 
		long					*oldIndex, 
		long					*newIndex
	);

#endif

#endif _H_OTLN
